/*
 The Techlabs Pure MVC Tutorial
 Copyright (c) 2009 Pedro Furtado (pedro.furtado@gmail.com)
 Your reuse is governed by the Creative Commons Attribution 3.0 License
*/
package com.techlabs.puremvc.controller
{
	import com.techlabs.puremvc.model.DataProxy;
	
	import org.puremvc.as3.interfaces.INotification;
	import org.puremvc.as3.patterns.command.SimpleCommand;

	public class RemoveFeedCommand extends SimpleCommand
	{
		/**
         * As the name says, this command will affect the dataProxy and remove the selected feed.
         */
		override public function execute(notification:INotification):void
		{
			var dataProxy:DataProxy = facade.retrieveProxy(DataProxy.NAME) as DataProxy;
			dataProxy.feeds.removeItemAt(notification.getBody() as int)
			dataProxy.saveData();
		}
		
	}
}